/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.database.jdbc;

import ibm.nways.jdm.database.DatabaseEvent;
import ibm.nways.jdm.database.jdbc.DbJdbcConnection;
import java.sql.SQLException;
import java.sql.Statement;

class DbJdbcWorker
implements Runnable {
    private Thread serviceThread;
    private DbJdbcConnection connection;

    public DbJdbcWorker(DbJdbcConnection dbJdbcConnection) {
        this.connection = dbJdbcConnection;
        this.serviceThread = new Thread(this);
    }

    public Thread getThread() {
        return this.serviceThread;
    }

    public void run() {
        DatabaseEvent databaseEvent;
        while (!(databaseEvent = this.connection.getNextWork()).getShutdown()) {
            this.doWork(databaseEvent);
            this.connection.notifyComplete(databaseEvent);
        }
        this.connection = null;
    }

    void start() {
        this.serviceThread.start();
    }

    void stop() {
        this.serviceThread.stop();
    }

    void doWork(DatabaseEvent databaseEvent) {
        try {
            Statement statement = this.connection.getConnection().createStatement();
            String string = databaseEvent.getSqlRequest();
            if (string.startsWith("DELETE") || string.startsWith("INSERT") || string.startsWith("UPDATE")) {
                databaseEvent.setReturnCode(statement.executeUpdate(string));
            } else {
                statement.execute(string);
            }
            statement.close();
            return;
        }
        catch (SQLException sQLException) {
            databaseEvent.setReturnCode(sQLException.getErrorCode());
            databaseEvent.setResults(sQLException);
            return;
        }
    }
}

